
      local ctx = {
        propsDef        = nil,  -- property definition
        propsDefInstall = nil, -- property definition install group
        propsDefSrc     = nil,  -- property definition (source scene)
        propsSet        = nil,  -- property settings (model)
        propsVal        = {},   -- property values
        propsValSrc     = nil,  -- property values (first source scene)
        scriptVar       = {},
        propsConfig     = nil,
    }
    
        ctx.scriptVar.game_name = false
        ctx.scriptVar.decimals = 0
        ctx.scriptVar.delay = 1400
        ctx.scriptVar.five_anim = true
        ctx.scriptVar.maxCount = 99
        ctx.scriptVar.minCount = 0
        ctx.scriptVar.type = "1"
        ctx.scriptVar.zeros = false
        local icon = "data:image/png;base64,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"
        local title = "Pixel Counter"
        local fontname = "Press Start 2P"
        local fontURL = "https://fonts.google.com/specimen/Press+Start+2P"
        local supportURL = "http://e.lga.to/counter-support"
    		local icon1 = "data:image/png;base64, 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"
        local description = [[
          <a href="https://marketplace.elgato.com/"><img height=50 src=']] .. icon1 .. [['/></a><br/>
          <p><h2>]] .. title .. [[</h2></p>
              <p>
             <center><img width=408 height=136 align="center" src=']] .. icon .. [['/></center>
            <p>
            Before importing your counter, make sure you've installed the required font.
            <p>Trouble setting up? <a href="]].. supportURL ..[[">Get help.</a>
            </p> 
            ]]


function install_scene(pressed)
            if not pressed then
                return
            end   
            local new_scene = nil
            local scene = nil
            local scene_name = ctx.propsVal.Scene_input
            scene_name = string.gsub(scene_name,'[%c%-%p]', '')

			if source_in_scene(scene_name) == true then
				ctx.propsVal.customScene = scene_name
				obs.obs_data_set_string(ctx.propsSet, "scene_name", scene_name)
				set_visibility() 
                local win_name = obs.obs_get_source_by_name(ctx.propsVal.customScene .. ' win count')
                local win_setting = obs.obs_source_get_settings(win_name)
                local win_count = obs.obs_data_get_string(win_setting, "text")
                ctx.propsVal.wcount = tonumber(win_count)
                ctx.scriptVar.winText = tonumber(win_count)
                obs.obs_data_set_int(settings, "wcount", ctx.propsVal.wcount)
                obs.obs_data_release(win_setting)
                obs.obs_source_release(win_name)
				if ctx.scriptVar.type == "2" or ctx.scriptVar.type == "3" then
					local loss_name = obs.obs_get_source_by_name(ctx.propsVal.customScene .. ' loss count')
					local loss_setting = obs.obs_source_get_settings(loss_name)
                    local loss_count = obs.obs_data_get_string(loss_setting, "text")
                    ctx.propsVal.lcount = tonumber(loss_count) 
                    ctx.scriptVar.lossText = tonumber(loss_count)
                    obs.obs_data_set_int(settings, "lcount", ctx.propsVal.lcount)
					obs.obs_data_release(loss_setting)
                    obs.obs_source_release(loss_name)
				end
				if ctx.scriptVar.type == "3" then
					local streak_name = obs.obs_get_source_by_name(ctx.propsVal.customScene .. " streak count")
                    if streak_name ~= nil then
                        local streak_setting = obs.obs_source_get_settings(streak_name)
                        local streak_count = obs.obs_data_get_string(streak_setting, "text")
                        ctx.propsVal.streakCount = tonumber(streak_count)
                        obs.obs_data_release(streak_settinga)
                        obs.obs_source_release(streak_name)
                    end
                    local rate_name = obs.obs_get_source_by_name(ctx.propsVal.customScene .. ' rate count')
                    if rate_name ~= nil then
                        win_stat()
                        obs.obs_source_release(rate_name)
                    end
				end
				return

			end

            new_scene, scene = create_scene(scene_name)

            local new_scene_source = obs.obs_scene_get_source(scene)
            local new_scene_source_name = obs.obs_source_get_name(new_scene_source)
            obs.obs_data_set_string(ctx.propsSet, "custom_scene", new_scene_source_name)
			obs.obs_data_set_string(ctx.propsSet, "scene_name", new_scene_source_name)
            obs.obs_properties_apply_settings(ctx.propsDef, ctx.propsSet)
			ctx.propsVal.customScene = new_scene_source_name
            ctx.propsVal.Scene_input = new_scene_source_name
            local videoInfo = obs.obs_video_info()
      obs.obs_get_video_info(videoInfo)
      if videoInfo.base_width >= 1920 then

    create_image(57, 0, 1, 1, true, 'assets/backgrounds/Background_00000.png', scene_name .. ' Background_00000.png', new_scene, scene, 0)
 create_loop_overlay(57, 0, 1, 1, true, 'assets/animations/Decrease.mov',scene_name .. ' decrease win animation', new_scene, scene, false, false, 0, 1)
 create_loop_overlay(57, 0, 1, 1, true, 'assets/animations/Increase.mov',scene_name .. ' increase win animation', new_scene, scene, false, false, 0, 2)
 create_loop_overlay(57, 0, 1, 1, true, 'assets/animations/Reset.mov',scene_name .. ' reset animation', new_scene, scene, false, false, 0, 3)
 create_text(-312, -134, 0.9742857217788696, 0.9739999771118164, true, 'Press Start 2P', 150, 'Regular', 4294967295, '0', true, 4280163870, 20, 'right', 'center', true, 700, 500, true, 100, false, 4294967295, 90, 100, scene_name .. ' win count', new_scene, scene, 4)
 
 else 
create_image(57, 0, 1, 1, true, 'assets/backgrounds/Background_00000.png', scene_name .. ' Background_00000.png', new_scene, scene, 0)
 create_loop_overlay(57, 0, 1, 1, true, 'assets/animations/Decrease.mov',scene_name .. ' decrease win animation', new_scene, scene, false, false, 0, 1)
 create_loop_overlay(57, 0, 1, 1, true, 'assets/animations/Increase.mov',scene_name .. ' increase win animation', new_scene, scene, false, false, 0, 2)
 create_loop_overlay(57, 0, 1, 1, true, 'assets/animations/Reset.mov',scene_name .. ' reset animation', new_scene, scene, false, false, 0, 3)
 create_text(-312, -134, 0.9742857217788696, 0.9739999771118164, true, 'Press Start 2P', 150, 'Regular', 4294967295, '0', true, 4280163870, 20, 'right', 'center', true, 700, 500, true, 100, false, 4294967295, 90, 100, scene_name .. ' win count', new_scene, scene, 4)
 
 end 
 set_visibility() 
 end 
 
--1.1.8
--script version ID:2.1.30
obs = obslua
null = nil

if tostring(package.config:sub(1,1)) == "/" then
    ctx.scriptVar.Os = "mac"
elseif tostring(package.config:sub(1,1)) == "\\" then
    ctx.scriptVar.Os = "windows"
end
print(ctx.scriptVar.Os)


ctx.scriptVar.lossText = 0
ctx.scriptVar.winText = 0
ctx.propsVal.streakCount = 0
ctx.propsVal.wcount = nil
ctx.propsVal.wcount = nil



hotkey_id_rs     = obs.OBS_INVALID_HOTKEY_ID
hotkey_id_win     = obs.OBS_INVALID_HOTKEY_ID
hotkey_id_wdc     = obs.OBS_INVALID_HOTKEY_ID
hotkey_id_lin     = obs.OBS_INVALID_HOTKEY_ID
hotkey_id_ldc     = obs.OBS_INVALID_HOTKEY_ID



function script_description()
	return description
end

if ctx.scriptVar.zeros == true then
	if ctx.scriptVar.maxCount > 0 then
		local countLength = math.floor(math.log10(ctx.scriptVar.maxCount)+1)
		ctx.scriptVar.zeros_pad = "%0" .. countLength .. "d"
	end
else
		ctx.scriptVar.zeros_pad = "%00d"
end

function updateSourceScenes()
	if ctx.propsDefSrc == nil then
		return 
	end
	obs.obs_property_list_clear(ctx.propsDefSrc)
	local scenes = obs.obs_frontend_get_scenes()
	if scenes == nil then
		return 
	end
		ctx.propsValSrc = "--Select--"
		obs.obs_property_list_add_string(ctx.propsDefSrc, ctx.propsValSrc, ctx.propsValSrc)
	for _, scene in ipairs(scenes) do
		local n = obs.obs_source_get_name(scene)
		if n ~= ctx.propsVal.customScene then
		obs.obs_property_list_add_string(ctx.propsDefSrc, n, n)
		end
		-- ctx.propsValSrc = n
	end
	obs.source_list_release(scenes)
	return true
end





function create_loop_overlay(xpos, ypos, xscale, yscale, visible, file_location, name, new_scene, scene, restart, loop, monitor, order)
	if source_exists(name) >= 1 then
	local name = name .. " " .. source_exists(name)
	end
	local pos = obs.vec2()
	local scale = obs.vec2()

	local overlay_settings = obs.obs_data_create()
	obs.obs_data_set_string(overlay_settings, "local_file", script_path() .. file_location)
	obs.obs_data_set_bool(overlay_settings, "looping", loop)
	obs.obs_data_set_bool(overlay_settings, "restart_on_activate", restart)
	local overlay_source = obs.obs_source_create("ffmpeg_source", name, overlay_settings, nil)
	obs.obs_scene_add(new_scene, overlay_source)

	local overlay_sceneitem = obs.obs_scene_find_source(scene, name)
	local overlay_location = pos
	local overlay_scale = scale
	if overlay_sceneitem then
		overlay_location.x = xpos
		overlay_location.y = ypos
		overlay_scale.x = xscale
		overlay_scale.y = yscale
		obs.obs_sceneitem_set_pos(overlay_sceneitem, overlay_location)
		obs.obs_sceneitem_set_scale(overlay_sceneitem, overlay_scale)
		obs.obs_sceneitem_set_visible(overlay_sceneitem, visible)
		obs.obs_sceneitem_set_order_position(overlay_sceneitem, order)
	end
	
	obs.obs_source_update(overlay_source, overlay_settings)
	obs.obs_data_release(overlay_settings)
    obs.obs_source_set_monitoring_type(overlay_source, monitor)
	obs.obs_source_release(overlay_source)

end

function create_image(xpos, ypos, xscale, yscale, visible, file_location, name, new_scene, scene, order)
	if source_exists(name) >= 1 then
		name = name .. " " .. source_exists(name)
	end
	local pos = obs.vec2()
	local scale = obs.vec2()

	local image_settings = obs.obs_data_create()
	obs.obs_data_set_string(image_settings, "file", script_path() .. file_location)
	local image_source = obs.obs_source_create("image_source", name, image_settings, nil)
	obs.obs_scene_add(new_scene, image_source)

	local image_sceneitem = obs.obs_scene_find_source(scene, name)
	local image_location = pos
	local image_scale = scale
	if image_sceneitem then
		image_location.x = xpos
		image_location.y = ypos
		image_scale.x = xscale
		image_scale.y = yscale
		obs.obs_sceneitem_set_pos(image_sceneitem, image_location)
		obs.obs_sceneitem_set_scale(image_sceneitem, image_scale)
		obs.obs_sceneitem_set_visible(image_sceneitem, visible)
		obs.obs_sceneitem_set_order_position(image_sceneitem, order)
	end
	obs.obs_source_update(image_source, image_settings)
	obs.obs_data_release(image_settings)
	obs.obs_source_release(image_source)

end

function create_text( x, y, xscale, yscale, visible, face, size, style, color, text, outline, outline_color, outline_size, align, valign, extents, extents_cx, extents_cy, extents_wrap, opacity, gradient, gradient_color,gradient_dir, gradient_opacity, name, new_scene, scene, order)
	if source_exists(name) >= 1 then
		name = name .. " " .. source_exists(name)
	end
	local pos = obs.vec2()
	local scale = obs.vec2()

	local text_settings = obs.obs_data_create()
	local text_font_object = obs.obs_data_create_from_json('{}')
	obs.obs_data_set_string(text_font_object, "face", face)
	obs.obs_data_set_int(text_font_object, "flags", 0)
	obs.obs_data_set_int(text_font_object, "size", size)
	obs.obs_data_set_string(text_font_object, "style", style)
	obs.obs_data_set_int(text_settings, "color", color)
	obs.obs_data_set_obj(text_settings, "font", text_font_object)
	obs.obs_data_set_string(text_settings, "text", text)
    obs.obs_data_set_bool(text_settings, "outline", outline)
    obs.obs_data_set_int(text_settings, "outline_color", outline_color)
    obs.obs_data_set_int(text_settings, "outline_size", outline_size)
	obs.obs_data_set_string(text_settings, "align", align)
	obs.obs_data_set_string(text_settings, "valign", valign)
	obs.obs_data_set_bool(text_settings, "extents", extents)
	obs.obs_data_set_int(text_settings, "extents_cx", extents_cx)
	obs.obs_data_set_int(text_settings, "extents_cy", extents_cy)
	obs.obs_data_set_bool(text_settings, "extents_wrap", extents_wrap)
	obs.obs_data_set_int(text_settings, "opacity", opacity)
	if gradient == true then
		obs.obs_data_set_bool(text_settings, "gradient", gradient)
		obs.obs_data_set_int(text_settings, "gradient_color", gradient_color)
		obs.obs_data_set_int(text_settings, "gradient_dir", gradient_dir)
		obs.obs_data_set_int(text_settings, "gradient_opacity", gradient_opacity)
	end

	local text_source = obs.obs_source_create("text_gdiplus", name, text_settings, nil)
	obs.obs_scene_add(new_scene, text_source)

	local text_sceneitem = obs.obs_scene_find_source(scene, name)
	local text_location = pos
	local text_scale = scale
	if text_sceneitem then
		text_location.x = x
		text_location.y = y
		text_scale.x = xscale
		text_scale.y = yscale
		obs.obs_sceneitem_set_pos(text_sceneitem, text_location)
		obs.obs_sceneitem_set_scale(text_sceneitem, text_scale)
		obs.obs_sceneitem_set_visible(text_sceneitem, visible)
		obs.obs_sceneitem_set_order_position(text_sceneitem, order)
	end

	obs.obs_source_update(text_source, text_settings)
	obs.obs_data_release(text_settings)
	obs.obs_data_release(text_font_object)
	obs.obs_source_release(text_source)

end


function reset(counter)
	if is_playing() == true then
		return
	end
	local anim_source_name = nil 
	local anim_source_name2 = nil
	local count = nil 
		anim_source_name = ctx.propsVal.customScene .. " reset animation"
		anim_source_name2 = ctx.propsVal.customScene .. " reset secondary animation"
	local anim_source = obs.obs_get_source_by_name(anim_source_name)
	local anim_source2 = obs.obs_get_source_by_name(anim_source_name2)

	local count = 0
	ctx.scriptVar.winText = string.format(ctx.scriptVar.zeros_pad, count)
	ctx.scriptVar.lossText = string.format(ctx.scriptVar.zeros_pad, count)
	if ctx.scriptVar.delay <= 0 then
		obs.obs_source_media_restart(anim_source)
		obs.obs_source_media_restart(anim_source2)
		update_count_win()
		if ctx.scriptVar.type == "2" or ctx.scriptVar.type == "3" then
			update_count_loss()
		end
	else
		obs.obs_source_media_restart(anim_source)
		obs.obs_source_media_restart(anim_source2)
		obs.timer_add(update_count_win, ctx.scriptVar.delay)
		if ctx.scriptVar.type == "2" or ctx.scriptVar.type == "3" then
			obs.timer_add(update_count_loss, ctx.scriptVar.delay)
		end
	end
	if anim_source ~= nil then
		obs.obs_source_release(anim_source)
	end
	if anim_source2 ~= nil then
		obs.obs_source_release(anim_source2)
	end
end



function win_count(direction)
	if is_playing() == true then
		return
	end
	local anim_source_name = nil 
	local anim_source_name2 = nil
	local count = ctx.propsVal.wcount
	if direction == "inc" then
		if tonumber(count) >= ctx.scriptVar.maxCount then
			ctx.scriptVar.triggerAction = nil
			return
		else
			count = count+1
		end
	elseif direction == "dec" then
		if tonumber(count) <= ctx.scriptVar.minCount  then
			ctx.scriptVar.triggerAction = nil
			return
		else
			count = count-1
		end
	end
	ctx.scriptVar.winText = string.format(ctx.scriptVar.zeros_pad, count)
	if ctx.scriptVar.five_anim == false then 
		anim_source_name = ctx.propsVal.customScene .. " win animation"
		anim_source_name2 = ctx.propsVal.customScene .. " win secondary animation"
	elseif direction == "inc" then
		anim_source_name = ctx.propsVal.customScene ..  " increase win animation"
		anim_source_name2 = ctx.propsVal.customScene ..  " increase secondary win animation"
	elseif direction == "dec" then
		anim_source_name = ctx.propsVal.customScene ..  " decrease win animation"
		anim_source_name2 = ctx.propsVal.customScene ..  " decrease secondary win animation"
	end
	local anim_source = obs.obs_get_source_by_name(anim_source_name)
	local anim_source2 = obs.obs_get_source_by_name(anim_source_name2)
		obs.timer_remove(update_count_win)
		obs.timer_remove(update_count_streak)
		obs.timer_remove(update_count_rate)
		if ctx.scriptVar.delay <= 0 then
			obs.obs_source_media_restart(anim_source)
			obs.obs_source_media_restart(anim_source2)
			update_count_win()
		else
			obs.obs_source_media_restart(anim_source)
			obs.obs_source_media_restart(anim_source2)
			obs.timer_add(update_count_win, ctx.scriptVar.delay)
		end
		if ctx.scriptVar.type == "3" then
				win_streak("win")
				win_stat()
		end
	if anim_source ~= nil then
		obs.obs_source_release(anim_source)
	end
	if anim_source2 ~= nil then
		obs.obs_source_release(anim_source2)
	end
end

function is_playing()
	if animation_list == nil then
		set_animation_list()
	end
	for i, animation in ipairs(animation_list) do
		local source = obs.obs_get_source_by_name(animation)
		if source ~= nil then
			local state = obs.obs_source_media_get_state(source)
			if state ~= 6 then
				obs.obs_source_release(source)
				return true
			end
		end
		obs.obs_source_release(source)
	end
	return false
end
function loss_count(direction)
	if is_playing() == true then
		return
	end
	local anim_source_name = nil 
	local anim_source_name2 = nil 
	local count = ctx.propsVal.lcount
	if direction == "inc" then
		if tonumber(count) == ctx.scriptVar.maxCount then
			ctx.scriptVar.triggerAction = nil
			return
		else
			count = count+1
		end
	elseif direction == "dec" then
		if tonumber(count) == ctx.scriptVar.minCount then
			ctx.scriptVar.triggerAction = nil
			return
		else
		count = count-1
		end
	end
	ctx.scriptVar.lossText = string.format(ctx.scriptVar.zeros_pad, count)
	if ctx.scriptVar.five_anim == false then 
		anim_source_name = ctx.propsVal.customScene .. " loss animation"
		anim_source_name2 = ctx.propsVal.customScene .. " loss secondary animation"
	elseif direction == "inc" then
		anim_source_name = ctx.propsVal.customScene ..  " increase loss animation"
		anim_source_name2 = ctx.propsVal.customScene ..  " increase secondary loss animation"
	elseif direction == "dec" then
		anim_source_name = ctx.propsVal.customScene ..  " decrease loss animation"
		anim_source_name2 = ctx.propsVal.customScene ..  " decrease secondary loss animation"
	end
	local anim_source = obs.obs_get_source_by_name(anim_source_name)
	local anim_source2 = obs.obs_get_source_by_name(anim_source_name2)
		obs.timer_remove(update_count_loss)
		obs.timer_remove(update_count_streak)
		obs.timer_remove(update_count_rate)
		if ctx.scriptVar.delay <= 0 then
			obs.obs_source_media_restart(anim_source)
			obs.obs_source_media_restart(anim_source2)
			update_count_loss()
		else
			obs.obs_source_media_restart(anim_source)
			obs.obs_source_media_restart(anim_source2)
			obs.timer_add(update_count_loss, ctx.scriptVar.delay)
		end
		if ctx.scriptVar.type == "3" then
				win_streak("loss")
				win_stat()
		end
	if anim_source ~= nil then
		obs.obs_source_release(anim_source)
	end
	if anim_source2 ~= nil then
		obs.obs_source_release(anim_source2)
	end

end

function set_count(count)
	if count == "win" then
		ctx.scriptVar.winText = ctx.propsVal.setwincount
		obs.timer_remove(update_count_win)
		update_count_win()
	elseif count == "loss" then
		ctx.scriptVar.lossText = ctx.propsVal.setlosscount
		obs.timer_remove(update_count_loss)
		update_count_loss()
	elseif count == "streak" then
		ctx.scriptVar.streakText = ctx.propsVal.setstreakcount
		obs.timer_remove(update_count_streak)
		update_count_streak()
	end

end

function win_stat()
	local action = ctx.scriptVar.triggerAction
	local count = nil
	if action == "reset" then 
		count = 0
	else
	local total_games = ctx.scriptVar.winText + ctx.scriptVar.lossText
	local win_ratio = ctx.scriptVar.winText / total_games
	count = round(win_ratio * 100, ctx.scriptVar.decimals)
	end
	if count ~= count then 
		count = 0
	end
	ctx.scriptVar.rateText = count
	if action == "set" then
		update_count_rate()
	elseif ctx.scriptVar.delay <= 0 or action == "set" then
		update_count_rate()
	else
		obs.timer_add(update_count_rate, ctx.scriptVar.delay)
	end
end

function round(number, decimals)
	local power = 10^decimals
	return math.floor(number * power) / power
end



function update_count_rate()
	obs.timer_remove(update_count_rate)
	local source_name = ctx.propsVal.customScene .. " rate count"
	local source = obs.obs_get_source_by_name(source_name)
	if source ~= nil then
		local settings = obs.obs_data_create()
		obs.obs_data_set_string(settings, "text", ctx.scriptVar.rateText .. "%") 
		obs.obs_source_update(source, settings)
		obs.obs_data_release(settings)
		obs.obs_source_release(source)
		ctx.propsVal.rateCount = ctx.scriptVar.rateText
		ctx.scriptVar.triggerAction = nil
	else
		print("missing rate count layer, check spelling")
	end
end

function win_streak() 
	local action = ctx.scriptVar.triggerAction
	local count = ctx.propsVal.streakCount
	if action == "win inc" then
		count = count+1
	elseif action == "win dec" then
		if count >= 1 then
			count = count-1
		else 
			count = 0
		end
		ctx.scriptVar.streakOld = count
	elseif action == "loss dec" then
		count = ctx.scriptVar.streakOld
	elseif action == "loss inc" or action == "reset" then
		ctx.scriptVar.streakOld = ctx.scriptVar.streakText
		count = 0
	end
	ctx.scriptVar.streakText = count
	if ctx.scriptVar.delay <= 0 then
		update_count_streak()
	else
		obs.timer_add(update_count_streak, ctx.scriptVar.delay)
	end
end


function update_count_win()
	obs.timer_remove(update_count_win)
	local source_name = ctx.propsVal.customScene .. " win count"
	local source = obs.obs_get_source_by_name(source_name)
	if source ~= nil then
		local settings = obs.obs_data_create()
		obs.obs_data_set_string(settings, "text", ctx.scriptVar.winText) 
		obs.obs_source_update(source, settings)
		obs.obs_data_release(settings)
		obs.obs_source_release(source)
		ctx.propsVal.wcount = ctx.scriptVar.winText
		if ctx.scriptVar.type == "1" or ctx.scriptVar.type == "2" then
			ctx.scriptVar.triggerAction = nil
		end
	else
		print("missing win count layer, check spelling")
	end
end

function update_count_loss()
	obs.timer_remove(update_count_loss)
	local source_name = ctx.propsVal.customScene .. " loss count"
	local source = obs.obs_get_source_by_name(source_name)
	if source ~= nil then
		local settings = obs.obs_data_create()
		obs.obs_data_set_string(settings, "text", ctx.scriptVar.lossText) 
		obs.obs_source_update(source, settings)
		obs.obs_data_release(settings)
		obs.obs_source_release(source)
		ctx.propsVal.lcount = ctx.scriptVar.lossText
		if ctx.scriptVar.type == "1" or ctx.scriptVar.type == "2" then
			ctx.scriptVar.triggerAction = nil
		end
	else
		print("missing loss count layer, check spelling")
	end
end

function update_count_streak()
	obs.timer_remove(update_count_streak)
	local source_name = ctx.propsVal.customScene .. " streak count"
	local source = obs.obs_get_source_by_name(source_name)
	if source ~= nil then
		local settings = obs.obs_data_create()
		obs.obs_data_set_string(settings, "text", ctx.scriptVar.streakText) 
		obs.obs_source_update(source, settings)
		obs.obs_data_release(settings)
		obs.obs_source_release(source)
		ctx.propsVal.streakCount = ctx.scriptVar.streakText
		ctx.scriptVar.triggerAction = nil
	else
		print("missing streak count layer, check spelling")
	end
end



function source_exists(name)
	local source_names = obs.obs_enum_sources()
	local value = 0

	for i, source in ipairs(source_names) do
		local current_checked_source_name = obs.obs_source_get_name(source_names[i])
		if string.find(current_checked_source_name, name) then
			value = value + 1
		end
	end
	obs.source_list_release(source_names)
	return value
end


function source_in_scene(scene_name)
	if scene_name ~= nil then
		local source_name = ctx.propsVal.Scene_input .. " win count"
		local obs_scene_name = obs.obs_get_source_by_name(scene_name)
		local scene = obs.obs_scene_from_source(obs_scene_name)
		if obs.obs_scene_find_source_recursive(scene, source_name) ~= nil then
			obs.obs_source_release(obs_scene_name)
			return true
		end
		obs.obs_source_release(obs_scene_name)
	end
	return false
end


function create_scene(scene_name)
	local scene_name = scene_name
	local new_scene = obs.obs_scene_create(scene_name)

	obs.obs_frontend_set_current_scene(obs.obs_scene_get_source(new_scene))
	local current_scene = obs.obs_frontend_get_current_scene()
	local scene = obs.obs_scene_from_source(current_scene)

	obs.obs_scene_release(new_scene)
	obs.obs_scene_release(scene)

	return new_scene, scene

end






function add_counter_toscene(pressed)
	local source_scene_name = ctx.propsVal.sourceScene
	if source_scene_name == "--Select--" then
		return
	end
	local count_scene_name = ctx.propsVal.customScene
	obs.obs_frontend_set_current_scene(source_scene_name)
	local scene_source = obs.obs_get_source_by_name(source_scene_name)
	local count_source = obs.obs_get_source_by_name(count_scene_name)
	local scene_scene = obs.obs_scene_from_source(scene_source)
	if scene_source ~= nil then
		obs.obs_frontend_set_current_scene(scene_source)
		obs.obs_scene_add(scene_scene,count_source)
	end
	obs.obs_source_release(scene_source)
	obs.obs_source_release(count_source)
end



function import_pressed(props, p)
	install_scene(true)
	return true
end

function add_to_scene_pressed(props, p)
	add_counter_toscene(true)
	return false
end

function set_game_name(props, p)
	local source_name = ctx.propsVal.customScene .. " game name"
	local source = obs.obs_get_source_by_name(source_name)
	if source ~= nil then
		local settings = obs.obs_data_create()
		obs.obs_data_set_string(settings, "text", ctx.propsVal.gameName) 
		obs.obs_source_update(source, settings)
		obs.obs_data_release(settings)
		obs.obs_source_release(source)
	end
end

function set_win_count_pressed(props, p)
	ctx.scriptVar.triggerAction = "set"
	set_count("win")
	if ctx.scriptVar.type == "3" then
		ctx.scriptVar.triggerAction = "set"
		win_stat()
	end
end

function set_streak_count_pressed(props, p)
	ctx.scriptVar.triggerAction = "set"
	set_count("streak")
end

function set_loss_count_pressed(props, p)
	ctx.scriptVar.triggerAction = "set"
	set_count("loss")
	if ctx.scriptVar.type == "3" then
		ctx.scriptVar.triggerAction = "set"
		win_stat()
	end
end

function hotkey_win_inc(pressed)
	if not pressed or ctx.scriptVar.triggerAction == "loss dec" or ctx.scriptVar.triggerAction == "loss inc" or ctx.scriptVar.triggerAction == "reset" or is_playing() == true then
		return
	end   
	ctx.scriptVar.triggerAction = "win inc"
	win_count("inc")

end

function hotkey_win_dec(pressed)
	if not pressed or ctx.scriptVar.triggerAction == "loss dec" or ctx.scriptVar.triggerAction == "loss inc" or ctx.scriptVar.triggerAction == "reset" or is_playing() == true then
		return
	end   
	ctx.scriptVar.triggerAction = "win dec"
	win_count("dec")
end

function hotkey_reset(pressed)
	if not pressed or ctx.scriptVar.triggerAction == "loss dec" or ctx.scriptVar.triggerAction == "loss inc" or ctx.scriptVar.triggerAction == "win dec" or ctx.scriptVar.triggerAction == "win inc" or is_playing() == true then
		return
	end   
	ctx.scriptVar.triggerAction = "reset"
	reset("win")
	reset("loss")
	if ctx.scriptVar.type == "3" then
				win_streak()
				win_stat()
		end
end

function hotkey_loss_inc(pressed)
	if not pressed or ctx.scriptVar.triggerAction == "win dec" or ctx.scriptVar.triggerAction == "win inc" or ctx.scriptVar.triggerAction == "reset" or is_playing() == true then
		return
	end   
	ctx.scriptVar.triggerAction = "loss inc"
	loss_count("inc")
end

function hotkey_loss_dec(pressed)
	if not pressed or ctx.scriptVar.triggerAction == "win dec" or ctx.scriptVar.triggerAction == "win inc" or ctx.scriptVar.triggerAction == "reset" or is_playing() == true then
		return
	end   
	ctx.scriptVar.triggerAction = "loss dec"
	loss_count("dec")
end

function open_url(url)
    if ctx.scriptVar.Os == "/" then
      os.execute('open "" "' .. fontURL .. '"')
    else
      os.execute('start "" "' .. fontURL .. '"')
    end
  end


function filename() 
	local str = debug.getinfo(2).source:sub(2) 
	return str:match("^.*/(.*).lua$") or str 
end

function set_animation_list()
	if ctx.scriptVar.five_anim == false and ctx.propsVal.customScene ~= nil then 
		animation_list = {
			ctx.propsVal.customScene .. " loss animation",
			ctx.propsVal.customScene .. " loss secondary animation",
			ctx.propsVal.customScene .. " win animation",
			ctx.propsVal.customScene .. " win secondary animation",
			ctx.propsVal.customScene .. " reset animation",
			ctx.propsVal.customScene .. " reset secondary animation",
		}
	elseif ctx.scriptVar.five_anim == true and ctx.propsVal.customScene ~= nil then
		animation_list = {
			ctx.propsVal.customScene ..  " increase loss animation",
			ctx.propsVal.customScene ..  " increase secondary loss animation",
			ctx.propsVal.customScene ..  " decrease loss animation",
			ctx.propsVal.customScene ..  " decrease secondary loss animation",
			ctx.propsVal.customScene ..  " increase win animation",
			ctx.propsVal.customScene ..  " increase secondary win animation",
			ctx.propsVal.customScene ..  " decrease win animation",
			ctx.propsVal.customScene ..  " decrease secondary win animation",
			ctx.propsVal.customScene ..  " reset animation",
			ctx.propsVal.customScene ..  " reset secondary animation",
		}
	end
end


function set_visibility()
	if ctx.propsVal.Scene_input == ctx.propsVal.customScene then
		local custom_name = obs.obs_properties_get(ctx.propsDefInstall, "custom_scene")
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "install_font_button"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "font_label"), false)
		obs.obs_property_set_long_description( custom_name, "Name of created counter.\nCan not be changed. Do not change the name of the scene listed." )
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "import_label"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "import_all_button"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "space_label"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "config_label"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "space_label_1"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "sourceScene"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "scene_label"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "add_toScene_button"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "space_label_2"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "wstart_label"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "wcount"), true)
		obs.obs_property_set_enabled(obs.obs_properties_get(ctx.propsDef, "custom_scene"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "set_win_count_button"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "lstart_label"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "lcount"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "set_loss_count_button"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "space_label_3"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "sstart_label"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "scount"), true)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "set_streak_count_button"), true)
		if ctx.scriptVar.game_name == true then
			obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "game_label"), true)
			obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "game_name"), true)
			obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "set_game_name_button"), true)
			obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "space_label_4"), true)
		else
			obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "game_label"), false)
			obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "game_name"), false)
			obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "set_game_name_button"), false)
			obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "space_label_4"), false)
		end
	end
	if ctx.propsVal.Scene_input ~= ctx.propsVal.customScene then 
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "config_label"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "space_label_1"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "sourceScene"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "scene_label"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "add_toScene_button"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "space_label_2"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "wstart_label"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "wcount"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "set_win_count_button"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "lstart_label"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "lcount"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "set_loss_count_button"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "space_label_3"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "sstart_label"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "scount"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "set_streak_count_button"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "game_label"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "game_name"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "set_game_name_button"), false)
		obs.obs_property_set_visible(obs.obs_properties_get(ctx.propsDef, "space_label_4"), false)
	end
end

function script_properties()
	ctx.propsDef = obs.obs_properties_create()
	ctx.propsDefInstall = obs.obs_properties_create()
	ctx.propsConfig = obs.obs_properties_create()
	obs.obs_properties_add_group( ctx.propsDef, "_group_install", "Installation", obs.OBS_GROUP_NORMAL, ctx.propsDefInstall )
	obs.obs_properties_add_group( ctx.propsDef, "_group_config", "Configuration", obs.OBS_GROUP_NORMAL, ctx.propsConfig )   

	local lable_font_name = obs.obs_properties_add_text(ctx.propsDefInstall, "font_label", "Font required: " .. fontname, obs.OBS_TEXT_INFO)
    local install_font_button = obs.obs_properties_add_button(ctx.propsDefInstall, "install_font_button", "Get font", open_url)
	local font_tooltip = obs.obs_property_set_long_description( install_font_button, "All fonts provided free by our friends at Google Fonts, Fontsgeek, DaFont, and more" )

		local lable_custom_name = obs.obs_properties_add_text(ctx.propsDefInstall, "custom_label", "Scene name", obs.OBS_TEXT_INFO)
		local custom_name = obs.obs_properties_add_text(ctx.propsDefInstall, "custom_scene", "", obs.OBS_TEXT_DEFAULT)
		local name_tooltip = obs.obs_property_set_long_description( custom_name, "Importing your counter creates a new scene" )
		local import_all_button = obs.obs_properties_add_button(ctx.propsDefInstall, "import_all_button", "Import counter", import_pressed)
        local import_button_tooltip = obs.obs_property_set_long_description( import_all_button, "Always remember to install font before importing" )


	local lable_installation = obs.obs_properties_add_text(ctx.propsConfig, "scene_label", "Add to scene (optional)", obs.OBS_TEXT_INFO)
	
	ctx.propsDefSrc = obs.obs_properties_add_list(ctx.propsConfig, "sourceScene", "", obs.OBS_COMBO_TYPE_LIST, obs.OBS_COMBO_FORMAT_STRING)
	obs.obs_property_set_long_description( ctx.propsDefSrc, "Add your counter as a source in an existing scene" )
	local add_toScene = obs.obs_properties_add_button(ctx.propsConfig, "add_toScene_button", "Add", add_to_scene_pressed)
	local lable_space1 = obs.obs_properties_add_text(ctx.propsConfig, "space_label_1", "", 3)

	local lable_game_name = obs.obs_properties_add_text(ctx.propsConfig, "game_label", "Title", obs.OBS_TEXT_INFO)
	local game_name = obs.obs_properties_add_text(ctx.propsConfig, "game_name", "", obs.OBS_TEXT_DEFAULT)
	local name_tooltip = obs.obs_property_set_long_description( game_name, "Display your game or team title" )
	local set_game_name = obs.obs_properties_add_button(ctx.propsConfig, "set_game_name_button", "Save changes", set_game_name)
	local lable_space4 = obs.obs_properties_add_text(ctx.propsConfig, "space_label_4", "", 3)

	local lable_wconfig = obs.obs_properties_add_text(ctx.propsConfig, "wstart_label", "Wins", obs.OBS_TEXT_INFO)
	local setting_wcount = obs.obs_properties_add_int(ctx.propsConfig, "wcount", "", ctx.scriptVar.minCount, ctx.scriptVar.maxCount, 1)
	obs.obs_property_set_long_description( setting_wcount, "Set your win counter to a preset number" )

	local add_toScene = obs.obs_properties_add_button(ctx.propsConfig, "set_win_count_button", "Save changes", set_win_count_pressed)

	if ctx.scriptVar.type == "2" or ctx.scriptVar.type == "3" then 
		local lable_space2 = obs.obs_properties_add_text(ctx.propsConfig, "space_label_2", "", 3)
		local lable_lconfig = obs.obs_properties_add_text(ctx.propsConfig, "lstart_label", "Losses", obs.OBS_TEXT_INFO)
		local setting_lcount = obs.obs_properties_add_int(ctx.propsConfig, "lcount", "", ctx.scriptVar.minCount, ctx.scriptVar.maxCount, 1)
		obs.obs_property_set_long_description( setting_lcount, "Set your loss counter to a preset number" )

		local add_toScene = obs.obs_properties_add_button(ctx.propsConfig, "set_loss_count_button", "Save changes", set_loss_count_pressed)
	end

	if ctx.scriptVar.type == "3" then 
		local lable_space3 = obs.obs_properties_add_text(ctx.propsConfig, "space_label_3", "", 3)
		local lable_sconfig = obs.obs_properties_add_text(ctx.propsConfig, "sstart_label", "Win streak", obs.OBS_TEXT_INFO)
		local setting_scount = obs.obs_properties_add_int(ctx.propsConfig, "scount", "", ctx.scriptVar.minCount, ctx.scriptVar.maxCount, 1)
		obs.obs_property_set_long_description( setting_scount, "Set your win streak to a preset number" )

		local set_streak = obs.obs_properties_add_button(ctx.propsConfig, "set_streak_count_button", "Save changes", set_streak_count_pressed)
	end

	obs.obs_property_set_modified_callback(obs.obs_properties_get(ctx.propsDef, "sourceScene"), updateSourceScenes)

	obs.obs_properties_apply_settings(ctx.propsDef, ctx.propsSet)
	set_visibility()
	return ctx.propsDef

end



function script_update(settings)
	ctx.propsSet = settings
	ctx.propsVal.sourceScene   = obs.obs_data_get_string(settings, "sourceScene")
	ctx.propsVal.Scene_input = obs.obs_data_get_string(settings, "custom_scene")
	ctx.propsVal.setwincount = obs.obs_data_get_int(settings, "wcount") 
	ctx.propsVal.setlosscount = obs.obs_data_get_int(settings, "lcount")
	ctx.propsVal.setstreakcount = obs.obs_data_get_int(settings, "scount")
	ctx.propsVal.gameName = obs.obs_data_get_string(settings, "game_name")

end

function script_defaults(settings)
	updateSourceScenes()
	obs.obs_data_set_default_string(settings, "sourceScene",   propsValSrc)
	obs.obs_data_set_default_int(settings, "count", 0)
	obs.obs_data_set_default_string(settings, "custom_scene", title)
	obs.obs_data_set_default_string(settings, "game_name", "")
	ctx.propsVal.wcount = obs.obs_data_get_int(settings, "wcount")
	ctx.propsVal.lcount = obs.obs_data_get_int(settings, "lcount")
	ctx.propsVal.streakCount = obs.obs_data_get_int(settings, "scount")
	ctx.propsVal.Scene_input = obs.obs_data_get_string(settings, title)
end

function script_save(settings)
	obs.obs_data_set_int(settings, "wcount", ctx.propsVal.wcount)
	obs.obs_data_set_int(settings, "lcount", ctx.propsVal.lcount)
	obs.obs_data_set_int(settings, "scount", ctx.propsVal.streakCount)
	obs.obs_data_set_string(settings, "scene_name", ctx.propsVal.customScene)

		local hotkey_save_array = obs.obs_hotkey_save(hotkey_id_rs)
		obs.obs_data_set_array(settings, "reset_hotkey", hotkey_save_array)
		obs.obs_data_array_release(hotkey_save_array)

		hotkey_save_array = obs.obs_hotkey_save(hotkey_id_win)
		obs.obs_data_set_array(settings, "wadd_hotkey", hotkey_save_array)
		obs.obs_data_array_release(hotkey_save_array)
		
		hotkey_save_array = obs.obs_hotkey_save(hotkey_id_wdc)
		obs.obs_data_set_array(settings, "wsub_hotkey", hotkey_save_array)
		obs.obs_data_array_release(hotkey_save_array)



		if ctx.scriptVar.type == "2" or ctx.scriptVar.type == "3" then 
			hotkey_save_array = obs.obs_hotkey_save(hotkey_id_lin)
			obs.obs_data_set_array(settings, "ladd_hotkey", hotkey_save_array)
			obs.obs_data_array_release(hotkey_save_array)
			
			hotkey_save_array = obs.obs_hotkey_save(hotkey_id_ldc)
			obs.obs_data_set_array(settings, "lsub_hotkey", hotkey_save_array)
			obs.obs_data_array_release(hotkey_save_array)

		end

end


function script_load(settings)
	ctx.scriptVar.winText = obs.obs_data_get_int(settings, "wcount")
	ctx.scriptVar.lossText = obs.obs_data_get_int(settings, "lcount")
	ctx.scriptVar.streakText = obs.obs_data_get_int(settings, "scount")
	ctx.propsVal.customScene = obs.obs_data_get_string(settings, "scene_name")
    ctx.propsVal.Scene_input = obs.obs_data_get_string(settings, "custom_scene")

		hotkey_id_rs = obs.obs_hotkey_register_frontend("wreset_" .. title:lower():gsub('[%W%p%c%s]', '') ..  "_count", "Reset Counter " .. title:gsub('[%c%-%p]', ''), hotkey_reset)
		local hotkey_save_array = obs.obs_data_get_array(settings, "reset_hotkey")
		obs.obs_hotkey_load(hotkey_id_rs, hotkey_save_array)
		obs.obs_data_array_release(hotkey_save_array)

		hotkey_id_win = obs.obs_hotkey_register_frontend("wincrease_" .. title:lower():gsub('[%W%p%c%s]', '') .. "_count", "Increase Win Counter  " .. title:gsub('[%c%-%p]', ''), hotkey_win_inc)
		hotkey_save_array = obs.obs_data_get_array(settings, "wadd_hotkey")
		obs.obs_hotkey_load(hotkey_id_win, hotkey_save_array)
		obs.obs_data_array_release(hotkey_save_array)

		hotkey_id_wdc = obs.obs_hotkey_register_frontend("wDecrease_" .. title:lower():gsub('[%W%p%c%s]', '') .. "_count", "Decrease Win Counter " .. title:gsub('[%c%-%p]', ''), hotkey_win_dec)
		hotkey_save_array = obs.obs_data_get_array(settings, "wsub_hotkey")
		obs.obs_hotkey_load(hotkey_id_wdc, hotkey_save_array)
		obs.obs_data_array_release(hotkey_save_array)
		
		if ctx.scriptVar.type == "2" or ctx.scriptVar.type == "3" then 

			hotkey_id_lin = obs.obs_hotkey_register_frontend("lincrease_" .. title:lower():gsub('[%W%p%c%s]', '') .. "_count", "Increase  Loss Counter " .. title:gsub('[%c%-%p]', ''), hotkey_loss_inc)
			hotkey_save_array = obs.obs_data_get_array(settings, "ladd_hotkey")
			obs.obs_hotkey_load(hotkey_id_lin, hotkey_save_array)
			obs.obs_data_array_release(hotkey_save_array)
		
			hotkey_id_ldc = obs.obs_hotkey_register_frontend("lDecrease_" .. title:lower():gsub('[%W%p%c%s]', '') .. "_count", "Decrease  Loss Counter " .. title:gsub('[%c%-%p]', ''), hotkey_loss_dec)
			hotkey_save_array = obs.obs_data_get_array(settings, "lsub_hotkey")
			obs.obs_hotkey_load(hotkey_id_ldc, hotkey_save_array)
			obs.obs_data_array_release(hotkey_save_array)
		end
end